<?php include 'header-link.php'; ?>

<?php
 // Retrieve data
$sql = "SELECT bill_pay.id,student.username, student.number,bill_pay.account_no, bill_pay.bill_org, bill_pay.bill_date, bill_pay.holder_name, bill_pay.holder_mobile,
bill_pay.amount, bill_pay.area,bill_pay.status  FROM bill_pay 
left join student on bill_pay.userid = student.userid
ORDER BY FIELD(bill_pay.status, 'Pending', 'Accepted', 'Rejected') ASC";
$result = $con->query($sql);
$sl=0;

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_id'])) {
$delete_id = $_POST['delete_id'];
$delete_sql = "DELETE FROM bill_pay WHERE id = ?";
$stmt = $con->prepare($delete_sql);
$stmt->bind_param("i", $delete_id);
$stmt->execute();
header("Location: bill-pay-rqst.php"); 
exit();
}
?>


<main>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-solid fa-money-bills-simple"></i>
                            </div>

                            <h6 class="card-title text-center my-3"> Bill Pay Request (<?php echo $billPay; ?>) </h6>
                           
                            

                            <input type="text" class="form-control mb-4" id="searchInput" placeholder="Search User..." onkeyup="filterOffers()">


                            <div class="offer-list" id="offerList">
                                <?php if ($result->num_rows > 0): ?>
                                <?php while($row = $result->fetch_assoc()): ?>
                                    <div class="offer-card mb-5 p-3" data-sim="<?php echo $offer['offer_sim']; ?>">
                                        <div class="row">
                                            <div class="col">
                                                <small class="fw-bold">User Name: <?php echo $row['username']; ?></small><br>
                                                <small>User Contact: <?php echo $row['number']; ?></small><br>
                                                <small> Name : <?php echo $row['holder_name']; ?></small><br>
                                                <small>Mobile: <?php echo $row['holder_mobile']; ?></small><br>
                                                <small>Status: <?php echo $row['status']; ?></small><br>
                                            </div>
                                            <div class="col text-end">
                                                <small>SMS/ACC No: <?php echo $row['account_no']; ?> </small><br>
                                                <small >Bill Type: <?php echo $row['bill_org']; ?> </small><br>
                                                <small class="fw-bold">Ammount: <?php echo $row['amount']; ?> </small><br>
                                                <small>Bill Date: <?php echo $row['bill_date']; ?></small><br>
                                                <small> Area : <?php echo $row['area']; ?></small>
                                            </div>
                                        </div>
                                        <div class="d-grid text-center">
                                        <a class="btn custom-button mx-3" href="edit-bill-pay.php?id=<?php echo $row['id']; ?>"> <i
                                        class="font fa-solid fa-eye"></i> View </a>  
                                        </div>
                                    </div>
                                <?php endwhile; ?>
                                <?php else: ?>
									<small>No records found.</small>
									<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<script>
function filterOffers() {
    const searchInput = document.getElementById('searchInput').value.toLowerCase();
    const offerCards = document.querySelectorAll('.offer-card');

    offerCards.forEach(card => {
        const cardText = card.textContent.toLowerCase();
        
        if (cardText.includes(searchInput)) {
            card.style.display = ''; // Show the card
        } else {
            card.style.display = 'none'; // Hide the card
        }
    });
}
</script>


</body>
</html>
